/*
 * Decompiled with CFR 0.152.
 */
package com.trackingpremium.report.utils;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

@Component
public class ImageService {
    private final RestTemplate restTemplate = new RestTemplate();
    @Value(value="${app.tokens.clients.web}")
    private String token;

    public boolean doesImageExist(String imageUrl) {
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", "Bearer " + this.token);
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(imageUrl, HttpMethod.HEAD, entity, String.class, new Object[0]);
            return response.getStatusCode() == HttpStatus.OK;
        }
        catch (HttpClientErrorException e) {
            System.err.println("Error al acceder a la imagen: " + String.valueOf(e.getStatusCode()) + " - " + e.getMessage());
            return false;
        }
        catch (Exception e) {
            System.err.println("Error de conexi\u00f3n al validar la URL: " + e.getMessage());
            return false;
        }
    }
}

