/*
 * Decompiled with CFR 0.152.
 */
package com.trackingpremium.report.controller;

import com.trackingpremium.report.dto.CompanyRequest;
import com.trackingpremium.report.dto.ReportDetail;
import com.trackingpremium.report.dto.ReportResponse;
import com.trackingpremium.report.service.ReportService;
import jakarta.servlet.http.HttpServletResponse;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/reports"})
public class ReportController {
    private final ReportService reportService;
    private static final String TEMP_DIR = System.getProperty("java.io.tmpdir") + "/tp_reports";
    private static final String[] ALLOWED_DOCUMENT_TYPES = new String[]{"Guide", "Receipt", "Warehouse", "LoadUnit", "Consolidated", "Lockers", "Invoice", "Location", "Payment", "Dashboard", "Pickup", "ShippingRequests"};
    private static final String[] ALLOWED_DOCUMENT_FORMATS = new String[]{"html", "pdf", "xlsx", "csv"};

    @Autowired
    public ReportController(ReportService reportService) {
        this.reportService = reportService;
    }

    private boolean validateAllowedValue(String value, String[] allowedValues) {
        for (String allowedValue : allowedValues) {
            if (!value.equals(allowedValue)) continue;
            return true;
        }
        return false;
    }

    private ResponseEntity<?> createErrorResponse(String error, String message) {
        HashMap<String, String> errorResponse = new HashMap<String, String>();
        errorResponse.put("error", error);
        errorResponse.put("message", message);
        return ResponseEntity.badRequest().body(errorResponse);
    }

    @PostMapping(value={"/generate"})
    public ResponseEntity<?> generateReport(HttpServletResponse response, @RequestBody Map<String, Object> requestBody) throws Exception {
        try {
            String company = (String)requestBody.get("company");
            String type = (String)requestBody.get("type");
            String name = (String)requestBody.get("name");
            String format = (String)requestBody.get("format");
            Map params = (Map)requestBody.get("params");
            if (company == null || company.trim().isEmpty()) {
                return this.createErrorResponse("Required parameter", "The 'company' parameter cannot be null or empty");
            }
            if (name == null || name.trim().isEmpty()) {
                return this.createErrorResponse("Required parameter", "The 'name' parameter cannot be null or empty");
            }
            if (type == null || type.trim().isEmpty()) {
                return this.createErrorResponse("Required parameter", "The 'type' parameter cannot be null or empty");
            }
            boolean isValidType = this.validateAllowedValue(type, ALLOWED_DOCUMENT_TYPES);
            if (!isValidType) {
                return this.createErrorResponse("Invalid value", "The 'type' parameter must be one of the following values: " + String.join((CharSequence)", ", ALLOWED_DOCUMENT_TYPES));
            }
            if (format == null || format.trim().isEmpty()) {
                return this.createErrorResponse("Required parameter", "The 'format' parameter cannot be null or empty");
            }
            boolean isValidFormat = this.validateAllowedValue(format, ALLOWED_DOCUMENT_FORMATS);
            if (!isValidFormat) {
                return this.createErrorResponse("Invalid value", "The 'format' parameter must be one of the following values: " + String.join((CharSequence)", ", ALLOWED_DOCUMENT_FORMATS));
            }
            if (format.equalsIgnoreCase("html")) {
                String reportUrl = this.reportService.generateReport(company, type, name, params, format);
                HashMap<String, String> responseBody = new HashMap<String, String>();
                responseBody.put("url", reportUrl);
                return ResponseEntity.ok(responseBody);
            }
            this.reportService.generateReport(response, company, type, name, params, format);
            return ResponseEntity.ok().build();
        }
        catch (Exception e) {
            if (e.getMessage() != null && e.getMessage().contains("Could not find Jasper file")) {
                HashMap<String, Object> errorResponse = new HashMap<String, Object>();
                errorResponse.put("error", "Report not found");
                errorResponse.put("message", "The requested report does not exist in the system " + e.getMessage());
                return ResponseEntity.status((int)404).body(errorResponse);
            }
            throw e;
        }
    }

    @GetMapping(value={"/html/{filename}"})
    public ResponseEntity<Resource> getHtmlReport(@PathVariable String filename) {
        try {
            Path filePath = Paths.get(TEMP_DIR, filename);
            UrlResource resource = new UrlResource(filePath.toUri());
            if (resource.exists() && resource.isReadable()) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Type", new String[]{"text/html"})).body((Object)resource);
            }
            return ResponseEntity.notFound().build();
        }
        catch (Exception e) {
            return ResponseEntity.notFound().build();
        }
    }

    @PostMapping(value={"/list-custom-by-type"})
    public ResponseEntity<List<ReportResponse>> getCustomReportsByType(@RequestBody CompanyRequest request) {
        List<ReportResponse> reportes = this.reportService.obtenerReportesPersonalizadosPorTipo(request);
        if (reportes.isEmpty()) {
            return ResponseEntity.noContent().build();
        }
        return ResponseEntity.ok(reportes);
    }

    @PostMapping(value={"/list-custom"})
    public ResponseEntity<Map<String, List<ReportDetail>>> getCustomReports(@RequestBody CompanyRequest request) {
        Map<String, List<ReportDetail>> resultado = this.reportService.obtenerReportesAgrupados(request);
        return ResponseEntity.ok(resultado);
    }
}

